import React, { useState, useEffect, useCallback } from "react";
import { BrowserRouter as Router, Routes, Route } from "react-router-dom";

import {
  Authenticator,
  Button,
  TextField,
  Heading,
  Flex,
  View,
  Divider,
  Table,
  TableHead,
  TableRow,
  TableCell,
  TableBody,
  Image,
  SelectField,
} from "@aws-amplify/ui-react";
import Modal from "react-modal";
import { Amplify } from "aws-amplify";
import "@aws-amplify/ui-react/styles.css";
import { getUrl } from "aws-amplify/storage";
import { uploadData } from "aws-amplify/storage";
import { generateClient } from "aws-amplify/data";
import outputs from "../amplify_outputs.json";
import { getCurrentUser } from "aws-amplify/auth";
import Journal from "./Journal";
import Documents from "./Documents";
import Encrypt from "./Encrypt";
import Notes from "./Notes";
import Navigation from "./Navigation";
// Enable backend interactions.
Amplify.configure(outputs);
const client = generateClient({
  authMode: "userPool",
});

export default function App() {
  return (
    <Authenticator hideSignUp={true}>
      {({ signOut }) => (
        <>
          <h5
            style={{
              fontStyle: "italic",
              fontWeight: "bold",
              textAlign: "center",
            }}
          >
            Atxcloudapps
          </h5>

          <Router>
            <Navigation />
            <div>
              <Routes>
                <Route path="/" element={<Journal />} />
                <Route path="/documents" element={<Documents />} />
                <Route path="/encrypt" element={<Encrypt />} />
                <Route path="/notes" element={<Notes />} />
              </Routes>
            </div>

            {/* Footer with dynamic copyright */}
            <footer
              style={{
                textAlign: "center",
                marginTop: "2em",
                padding: "1em",
                backgroundColor: "#f8f9fa",
                display: "flex",
                justifyContent: "center",
                alignItems: "center",
                gap: "1em", // Adjust spacing between elements
                flexWrap: "wrap", // Ensures responsiveness
              }}
            >
              <span>© {new Date().getFullYear()} Atxcloudapps</span>
              <span>|</span>
              <a href="mailto:support@atxcloudapps.com" className="center-link">
                support@atxcloudapps.com
              </a>
            </footer>
          </Router>
        </>
      )}
    </Authenticator>
  );
}
